#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
#include "ctrl/BOLTPictures.h"
#include "ctrl/BOLTReport.h"
#include "BOLTFrm.h"
#include "form/BOLTforms.h"
#include "report/brParam.h"
#include "report/brRunnerPieces.h"
#include "report/brRunner.h"
#include "report/brPreview.h"
#include "report/brQuery.h"
#include "wx/statline.h"
#include <wx/datetime.h>
#include <wx/calctrl.h>
#include <wx/file.h>
#include <wx/wfstream.h>
#include <wx/protocol/ftp.h>
#include <wx/print.h>
#include <wx/progdlg.h>
#include <wx/mstream.h>
#include "math.h"

wxProgressDialog *gProg=NULL;

brRunner::brRunner(wxWindow *parent,BOLTdb *db, RECORD_ID recordId)
{
	this->db=db;
	this->recordId=recordId;
	this->parent=parent;
	this->ScreenPPI=96;
	this->UsePPI=96;
	morePages=false;
	cancelReport=false;
};

bool brRunner::DoViewReport(RECORD_ID reportId,int p)
{
	morePages=false;

	wxBitmap *bitmap;
	wxMemoryDC dc;
	wxCoord hi,wide;
	if (!this->GetParameters(reportId)) { return false; };

	wide=db->GetFValue("reportLayouts","width",reportId)*ScreenPPI;
	hi=db->GetFValue("reportLayouts","height",reportId)*ScreenPPI;
	bitmap=new wxBitmap(wide,hi);
	dc.SelectObject(*bitmap);
	wxRect tRect(0,0,wide,hi);
	DrawReport(reportId,dc,tRect,p);
	dc.SelectObject(wxNullBitmap);
	wxDialog *tDlg;
	tDlg=new wxDialog(parent,-1,"Report Viewer",wxDefaultPosition);
	wxBoxSizer *topSizer,*tSizer;
	topSizer=new wxBoxSizer(wxVERTICAL);
	topSizer->Add(new wxButton(tDlg,wxID_OK,"&Close"),0,wxALIGN_CENTER|wxALL,5);

	tSizer=new wxBoxSizer(wxVERTICAL);
	wxScrolledWindow *sWin=new wxScrolledWindow(tDlg,-1);
	tSizer->Add(new wxStaticBitmap(sWin,-1,*bitmap));
//	sWin->SetAutoLayout(TRUE);
	sWin->SetSizerAndFit(tSizer);
	sWin->SetScrollbars(1,1,bitmap->GetWidth(),bitmap->GetHeight());

	topSizer->Add(sWin,1,wxEXPAND|wxALL,5);
	tDlg->FindWindow(wxID_OK)->SetFocus();
	tDlg->SetSizerAndFit(topSizer);
//	tDlg->SetAutoLayout(TRUE);
//	topSizer->SetSizeHints(tDlg);
//	topSizer->Fit(tDlg);
	tDlg->SetSize(parent->GetSize());
	tDlg->Center();
	tDlg->ShowModal();
	tDlg->Destroy();
	//create a dialog w/scroll window, close button
	//create a staticBitmap
	//showmodal
	safe_delete(bitmap);
return true;
}

bool brRunner::DoPrintReport(RECORD_ID reportId,wxPrintData & printData,int p)
{
	morePages=false;
	wxString rTitle,pTitle;
	if (!this->GetParameters(reportId)) { return false; };
	rTitle=db->GetValue("reports","name",reportId);
	if (p>1)
	{
		pTitle.Printf("%s %d",rTitle.c_str(),p);
	} else { pTitle=rTitle; }
#ifdef _DEMO_
	wxMessageBox("Printing is disabled on this demonstration version of BOLT.","Demo Disable",wxOK,this->parent);
	this->DoViewReport(reportId,p);
#else
	//real stuff

wxPageSetupDialogData psData;

psData.SetPrintData(printData);
psData.EnableMargins(TRUE);
psData.SetDefaultInfo(TRUE);
wxPageSetupDialog printWin(this->parent,&psData);
printWin.ShowModal();
psData=printWin.GetPageSetupData();
psData.SetMarginTopLeft(wxPoint(0,0));
psData.SetMarginBottomRight(wxPoint(0,0));
//printData=psData.GetPrintData();
psData.ConvertToNative();
wxPrintDialogData pdData(psData.GetPrintData());

   
//	wxPrintDialogData pdData(printData);
    wxPrinter printer(&pdData);
    BOLTReport *printout=new BOLTReport(reportId,this,p,pTitle);
    if (!printer.Print(parent, printout, FALSE))
    {
        if (wxPrinter::GetLastError() == wxPRINTER_ERROR)
            wxMessageBox("There was a problem printing.\nPerhaps your current printer is not set correctly?", "Printing", wxOK);
        else
            wxMessageBox("You canceled printing", "Printing", wxOK);
   }
    else
    {
		//hmm
	}
	safe_delete(printout);
#endif
return true;
}

bool brRunner::DoSaveReport(RECORD_ID reportId,wxString & path,bool textonly,int p)
{
	morePages=false;

	wxBitmap *bitmap;
	wxMemoryDC dc;
	wxCoord hi,wide;
	wxFileOutputStream *mBuff;

//	this->ScreenPPI=96;
	if (!this->GetParameters(reportId)) { return false; };

	if (textonly)
	{
		mBuff=new wxFileOutputStream(path);
		if (!mBuff->Ok())
		{
			wxMessageBox("Could not open file.  Report not saved","Error Saving Report",wxICON_ERROR,this->parent); 
			delete mBuff;
			return false;
		}
		RunReport(reportId,mBuff);
		delete mBuff;
		return true; 
	} else {
	wide=db->GetFValue("reportLayouts","width",reportId) * ScreenPPI;
	hi=db->GetFValue("reportLayouts","height",reportId) * ScreenPPI;
	bitmap=new wxBitmap(wide,hi);
	dc.SelectObject(*bitmap);
	wxRect tRect(0,0,wide,hi);
	DrawReport(reportId,dc,tRect);
	dc.SelectObject(wxNullBitmap);
	if (bitmap->Ok())
	{ bitmap->SaveFile(path,wxBITMAP_TYPE_JPEG); }
	return true;
	}
	return false;
}

bool brRunner::DoSendReport(RECORD_ID reportId,wxString & path,wxString & server, wxString & user, wxString & pass, bool textonly, bool passive,int p)
{
	morePages=false;
	wxDialUpManager *dialUp;
	dialUp=wxGetApp().frame->dialUp;
	bool wasOnline;
	  wxFFileInputStream *fIn;

	wxString tPath;
	tPath=wxGetTempFileName("BOLTTransmit");
	if (!this->DoSaveReport(reportId,tPath,textonly))
	{
		LOG_ERROR("Could not generate report");
		return false;
	} 

	if (wxMessageBox("Report Generated, ready to send.\n Would you like to review the data before sending ?","Review Data",wxYES_NO,this->parent)==wxYES)
	{
		wxString execStr;
		wxString tePath;
		myConfig *config=wxGetApp().config;
		wxGetApp().config->SetPath("/");
		wxGetApp().config->Read("TextEditorPath",&tePath);
		bool cont=true;
		while (cont && (!wxFileExists(tePath)))
		{
			if(wxMessageBox("Please locate the text editor program","Not Found",wxOK|wxCANCEL,this->parent)==wxID_CANCEL)
			{ cont=false; }
			if (cont)
			{
				tePath=wxFileSelector("What program would you like to use to review the file ?",
							"/Program Files/Accessories",
							"wordpad", "exe","Executable|*.exe",wxFILE_MUST_EXIST,this->parent);
			}
		}
		wxGetApp().config->Write("TextEditorPath",tePath);

		execStr.Printf("%s %s",tePath.c_str(),tPath.c_str());
		wxMessageBox(execStr,"DEBUG",wxOK,this->parent);
		wxExecute(execStr,wxEXEC_SYNC);

		if (wxMessageBox("After reviewing the data, would you still like to send ?","Confirm Send",wxYES_NO,this->parent)==wxNO)
		{
			//cancel
				wxRemoveFile(tPath); 	 // remove the temp file
				return(0);
		}
	}

	wxProgressDialog *prog,*oProg;

	prog=new wxProgressDialog("Sending Report","Getting Online",6,(gProg==NULL)?this->parent:gProg,wxPD_CAN_ABORT|wxPD_AUTO_HIDE|wxPD_APP_MODAL);
	oProg=gProg;
	gProg=prog;
	wasOnline=TRUE;
	if (!dialUp->IsAlwaysOnline())
	{
		wasOnline=dialUp->IsOnline();
		while(!dialUp->IsOnline())
		{
			dialUp->Dial(wxEmptyString,wxEmptyString,wxEmptyString,FALSE);
			if (!dialUp->IsOnline())
			{ 
				if (wxMessageBox("Unable to connect to the internet.  Abort Report ?","Can't Connect",wxYES_NO,this->parent)==wxYES)
					{
					wxRemoveFile(tPath);
					delete prog; gProg=oProg;
					return false;
				}
			}
		}
	};

	prog->Update(1,"Online.  Generating Report.");

	wxFTP ftp;
	wxOutputStream *out_stream;

	prog->Update(1,"Generated.  Connecting to server...");
	ftp.SetUser(user);
	ftp.SetPassword(pass);
	while (!ftp.Connect(server))
	{
		LOG_ERROR(ftp.GetLastResult());
		if (wxMessageBox("Would you like to try to retry ?","Connection Error",wxYES_NO,prog)==wxNO)
		{
			wxRemoveFile(tPath);
			delete prog; gProg=oProg;
			return false;
		}
	}


	prog->Update(2,"Connected. Preparing Transfer");
//	ftp.SendCommand("BIN");
	if (passive) ftp.SendCommand("PASV");
	if (out_stream = ftp.GetOutputStream(path))
	{
	  prog->Update(3,"Connected. Ready. Sending Report");

	  fIn=new wxFFileInputStream(tPath);
	  void *tbuffer=malloc(fIn->GetSize()+1);
	  fIn->Read(tbuffer,fIn->GetSize());
	  out_stream->Write(tbuffer,fIn->GetSize());

	  //	  out_stream->Write(*fIn);

	  free(tbuffer);
	  if (out_stream->LastError() != wxStream_NOERROR) {
		// Do something.
		  wxMessageBox("Error Transmitting Report !!!","Error",wxOK,prog);
	  } 
	 safe_delete(out_stream);
	 safe_delete(fIn);/* Close the DATA connection */
	 wxRemoveFile(tPath); 	 // remove the temp file
	}
	else 
	{ 
		wxMessageBox(ftp.GetLastResult(),"Transmit Error",wxOK,prog);
	}
	prog->Update(4,"Closing Connection.");
	ftp.Close(); /* Close the COMMAND connection */

	prog->Update(5,"Finished.");

	if (!dialUp->IsAlwaysOnline())
	{
	  if ((!wasOnline)&&(dialUp->IsOnline()))
		{ dialUp->HangUp(); }
	}
	wxRemoveFile(tPath);
	gProg=oProg;
	delete prog;//   prog->Destroy();
	return true;
}

void brRunner::DrawReport(RECORD_ID reportId,wxDC & dc,wxRect & where,int p)
{
	//Erase Background 
	dc.SetBrush(*wxWHITE_BRUSH);
	dc.SetPen(*wxTRANSPARENT_PEN);
//	dc.SetPen(*wxBLACK_PEN);
	dc.SetDeviceOrigin(0,0);
	dc.SetUserScale(1,1);
	dc.DrawRectangle(where);
	dc.SetBrush(wxNullBrush);
	dc.SetPen(wxNullPen);
if (db->GetValue("reportLayouts","if(useImage,1,NULL)",reportId))
{
	this->DrawBackground(reportId,dc,where);
}
//TODO - margins ?
this->DrawQueries(reportId,dc,where,p);
}

void brRunner::DrawBackground(RECORD_ID reportId,wxDC & dc,wxRect & where)
{
	bcPicture *picture;
	wxCoord x,y;
//	wxCoord wi,hi;
//	double rwidth,rheight;

//	PPI=where.width/db->GetFValue
	picture=new bcPicture(db,"reportPictures",reportId,reportId);
		//load image
	picture->LoadFromDatabase();
	if (!picture->Ok()) { return; }
	dc.SetMapMode(wxMM_TEXT);
	x=where.x;
	y=where.y;
	if (picture->Ok())
	{
		if (db->GetValue("reportLayouts","imageScale",reportId))
		{
			this->DrawImageChunks(*picture,dc,wxRect(0,0,picture->GetWidth(),picture->GetHeight()),where);
		} else { 
			x=x+(picture->GetWidth()-where.width)/2;
			y=y+(picture->GetHeight()-where.height)/2;
//todo - drawimagechunks
			dc.DrawBitmap(picture->ConvertToBitmap(),x,y);
			wxRect tr(x,y,picture->GetWidth(),picture->GetHeight());
			this->DrawImageChunks(*picture,dc,wxRect(0,0,picture->GetWidth(),picture->GetHeight()),tr);
		
		}
	}
	safe_delete(picture);
}

void brRunner::DrawQueries(RECORD_ID reportId,wxDC & dc,wxRect & where,int p)
{
	QRY_ID qry;
	void *row;
	char *tmp;
	wxString tStr,tStr2;
	RECORD_ID queryId;
	double hscale,vscale,rw,rh;
	double mLeft,mTop;
	wxRect atR;
	bool drawit;
	rw=db->GetFValue("reportLayouts","width",reportId);
	rh=db->GetFValue("reportLayouts","height",reportId);
	hscale=(double)where.width/rw;
	vscale=(double)where.height/rh;
	mLeft=db->GetFValue("reportLayouts","mLeft",reportId);
	mTop=db->GetFValue("reportLayouts","mTop",reportId);

	wxString pageStr;
	pageStr.Printf("%d",p);
	this->SetParameter(wxString("PAGE"),pageStr);

	long numQuery,i;
		wxProgressDialog *prog,*oProg;
		wxString lStr;
	tStr.Printf("select count(id) from reportQueries where \
		reportId=%u",reportId);
	tStr2=db->GetQueryValue(tStr.c_str());
	tStr2.ToLong(&numQuery);
	
	tStr.Printf("select id from reportQueries where \
		reportId=%u order by runOrder desc",reportId);
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		i=0;
		prog=new wxProgressDialog("Gathering Data","Starting",numQuery+1,(gProg==NULL)?this->parent:gProg,wxPD_CAN_ABORT|wxPD_AUTO_HIDE|wxPD_APP_MODAL);
		oProg=gProg; gProg=prog;
		while ((row=db->FetchRow(qry)) && (!cancelReport)) {
			if (tmp=db->FetchQueryResult(qry,row,0))
			{
				queryId=atoi(tmp);
		
				tStr=db->GetValue("reportQueries","name",queryId);
				lStr.Printf("Gathering Data '%s'",tStr.c_str());
				cancelReport= !prog->Update(++i,lStr);
				atR.x = (db->GetFValue("reportQueryLayouts","x",queryId)+mLeft) * hscale+where.x;
				atR.y = (db->GetFValue("reportQueryLayouts","y",queryId)+mTop) * vscale+where.y;
				atR.width = floor(db->GetFValue("reportQueryLayouts","width",queryId) * hscale);
				atR.height = floor(db->GetFValue("reportQueryLayouts","height",queryId) * vscale);
				//clipping sorta :-P
				drawit=(atR.height > 0) && ( atR.width >0 );
				drawit=(!((atR.x < 0) && (atR.x+atR.width < 0))) && drawit;
				drawit=(!((atR.y < 0) && (atR.y+atR.height < 0))) && drawit;
				drawit=(atR.x < (where.x + where.width))&& drawit;
				drawit=(atR.y < (where.y + where.height))&& drawit;

				if ((drawit) && (!cancelReport))
				{ this->DrawQuery(queryId,dc,atR,p); }
			}
		}

		db->FreeQuery(qry);
		cancelReport= !prog->Update(++i,"Closing");
		gProg=oProg;
		delete prog; //prog->Destroy();
	}

}

void brRunner::DrawQuery(RECORD_ID queryId,wxDC & dc,wxRect & where,int p)
{
	char *tmp;
	wxString tStr;
	int qType,showOn;
	if (tmp=db->GetValue("reportQueryLayouts","type",queryId))
		{ qType=atoi(tmp); } 
	else
		{ return; }
	if (tmp=db->GetValue("reportQueryLayouts","DisplayPage",queryId))
		{ showOn=atoi(tmp); } 
	else
		{ showOn=0; }
	switch (showOn)
	{
		case 1:
			if (p!=1) {  return; }
			break;
		case 2:
			if (p==1) { return;}
			break;
	}
	wxBeginBusyCursor();
	switch (qType) {
		case RQ_TEXT:
			this->DrawText(queryId,dc,where,p);
			break;
		case RQ_STRING:
			this->DrawString(queryId,dc,where,p);
			break;
		case RQ_IMAGE:
			this->DrawImage(queryId,dc,where,p);
			break;
		case RQ_REPORT:
			this->DrawSubReport(queryId,dc,where,p);
			break;
	};
	wxEndBusyCursor();
}

bool brRunner::RunReport(RECORD_ID reportId,wxOutputStream *mBuff)
{
	QRY_ID qry;
	void *row;
	char *tmp;

	wxString tStr,qName;
	RECORD_ID queryId;
	wxProgressDialog *prog,*oProg;

	if (!mBuff) { LOG_ERROR("No Memory to run report into"); return false; }
	
	this->SetParameter(wxString("PAGE"),wxString("1"));

	tStr.Printf("select id,name from reportQueries where \
		reportId=%u order by runOrder",reportId);
	int i=0;
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		prog=new wxProgressDialog("Gathering Data","Starting",db->FetchNumRows(qry)+1,(gProg==NULL)?this->parent:gProg,wxPD_CAN_ABORT|wxPD_AUTO_HIDE|wxPD_APP_MODAL);
		oProg=gProg;gProg=prog;
		while ((row=db->FetchRow(qry)) && (!cancelReport)) {
			if (tmp=db->FetchQueryResult(qry,row,0))
			{
				queryId=atoi(tmp);
				qName=db->FetchQueryResult(qry,row,1);
				cancelReport=!prog->Update(i++,qName);
				RunQuery(queryId,mBuff);
			}
		}
		db->FreeQuery(qry);
		cancelReport|=(!prog->Update(i,"Closing"));
		gProg=oProg; delete prog; //prog->Destroy();
	}
	return !cancelReport;
}

bool brRunner::RunQuery(RECORD_ID queryId,wxOutputStream *mBuff)
{
	QRY_ID qry;
	void *row;
	char *tmp;
	unsigned long size;
	wxString tStr,tStr2,qName,pName,sep,tSep;
	int qType,max,i;
	size=0;
	qName=db->GetValue("reportQueries","name",queryId);
	if (tmp=db->GetValue("reportQueryLayouts","type",queryId))
		{ qType=atoi(tmp); } 
	else 
		{ return NULL; }
switch (qType) {
	case RQ_TEXT:
	case RQ_STRING:
	this->GetQuery(queryId,tStr);
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
//		tStr="";
		max=db->FetchNumCols(qry,NULL);
		while ((row=db->FetchRow(qry)) && (!cancelReport))
		{
			//new line
			for (i=0; i<max;i++)
			{
				if (i>0) 
				{ 
					sep=db->GetValue("reportQueryLayouts","valueSeparator",queryId);
					if (!sep.IsEmpty()) 
					{
						tSep.Printf("\n"); sep.Replace("\\n",tSep);
						tSep.Printf("\r"); sep.Replace("\\r",tSep);
						tSep.Printf("\t"); sep.Replace("\\t",tSep);
					}
					mBuff->Write(sep.c_str(),sep.Length());
//					tStr.Append(sep); 
				}
				if (tmp=db->FetchQueryResult(qry,row,i))
				{
					mBuff->Write(tmp,strlen(tmp));
				//	tStr.Append(tmp);
				}
			}
			sep=db->GetValue("reportQueryLayouts","recordSeparator",queryId);
			if (!sep.IsEmpty()) 
			{
				tSep.Printf("\n"); sep.Replace("\\n",tSep);
				tSep.Printf("\r"); sep.Replace("\\r",tSep);
				tSep.Printf("\t"); sep.Replace("\\t",tSep);
			}
					mBuff->Write(sep.c_str(),sep.Length());
			//tStr.Append(sep); 
		}
		db->FreeQuery(qry);
		} else { 
			if (db->IsError())
			{
				tStr.Printf("Query Error - %s - %s",qName.c_str(),db->GetError());
				LOG_ERROR(tStr.c_str());
				return FALSE;
	//			wxMessageBox(db->GetError(),tStr,wxICON_EXCLAMATION ,this->parent);
			}
			return false;
		}
		return true;
		break;
	case RQ_IMAGE:
		return false;		
		break;
	case RQ_REPORT:

	brRunner *subRunner;
	RECORD_ID subId;
	if (tmp=db->GetValue("reportQueryLayouts","subReportId",queryId))
	{ subId=atoi(tmp); } else { return NULL; }

	subRunner=new brRunner(parent,db,subId);

	this->GetQuery(queryId,tStr);
	max=0;
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
			while ((row=db->FetchRow(qry)) && (!cancelReport))
			{
				if (max==0) { max=db->FetchNumCols(qry,row); }
				if (max > 0)
				{
					subRunner->ClearParameters();
					this->SetParameter(wxString("PAGE"),wxString("1"));
					//fill parameter values
					for (i=0;i<max; i++)
					{
						tStr.Printf("select name from reportParameters where reportId=%u and runOrder=%d",subId,i+1);
						pName=db->GetQueryValue(tStr.c_str());
						tStr=db->FetchQueryResult(qry,row,i);
						subRunner->SetParameter(pName,tStr);
					}
					subRunner->RunReport(subId,mBuff);
					this->cancelReport=subRunner->cancelReport;
				}
			}
	db->FreeQuery(qry);
	}	else {
		if (db->IsError())
		{
			tStr.Printf("Query Error - %s - %s",qName.c_str(),db->GetError());
			LOG_ERROR(tStr.c_str());
//			wxMessageBox(db->GetError(),tStr,wxICON_EXCLAMATION ,this->parent);
		}
		tStr="";
	}
	safe_delete(subRunner);
	return true;
	break;
	default: 
		return false; 
	break;
	};

}

void brRunner::DrawString(RECORD_ID queryId,wxDC & dc,wxRect & where,int p)
{
QRY_ID qry;
void *row;
//char *tmp;
wxString tStr,sQuery;
int max,i,cols,c;
char *tmp;
wxCoord hSpacing,vSpacing,teW,teH;
double rowHigh,totHigh,dHigh;
double tmpHigh,tmpWidth;
double qHigh,qWidth,colWidth,scalex,scaley,tscale,linespace;
double myPPIx,myPPIy;
wxString qName;
qName=db->GetValue("reportQueries","name",queryId);

linespace=db->GetFValue("reportQueryLayouts","lineSpace",queryId);
qHigh=db->GetFValue("reportQueryLayouts","height",queryId);
qWidth=db->GetFValue("reportQueryLayouts","width",queryId);
hSpacing=db->GetFValue("reportQueryLayouts","hSpacing",queryId);
vSpacing=db->GetFValue("reportQueryLayouts","vSpacing",queryId);
tStr=db->GetValue("reportQueries","name",queryId);

if (tmp=db->GetValue("reportQueryLayouts","recordsPerRow",queryId))
{ cols=atoi(tmp); } else { cols=1; } if (cols==0) { cols=1; }
int recPerPage=0,currRec=0;
wxString limitStr;
bool hitPageMax=false;
recPerPage=db->GetIValue("reportQueryLayouts","RecordsPerPage",queryId);
limitStr="";
this->GetQuery(queryId,sQuery);
if (recPerPage > 0)
{
	if (p<=1)
	{ limitStr.Printf(" LIMIT %d",recPerPage+1); }
	else
	{ limitStr.Printf(" LIMIT %d,%d",recPerPage*(p-1),recPerPage+1); }
	sQuery.Append(limitStr.c_str());
}


myPPIx=floor((double)where.width/(double)qWidth);
myPPIy=floor((double)where.height/(double)qHigh);

scalex=((double)myPPIx/(double)this->ScreenPPI);
scaley=((double)myPPIy/(double)this->ScreenPPI);

dc.SetUserScale(scalex,scaley);
//dc.SetUserScale(1,1);

// *** Determine total height *** //
int qCnt=0;
currRec=0;
totHigh=0;
if (qry=db->Query(sQuery.c_str(),sQuery.Length()))
{
	c=1; rowHigh=0;
	while (((row=db->FetchRow(qry))!=NULL)&&(!hitPageMax))		//new line
	{
		max=db->FetchNumCols(qry,row);
		qCnt++;
		tStr="";
		for (i=0; i<max;i++)
		{
			tStr.Append(db->FetchQueryResult(qry,row,i));
		}
		MyTextExtent(dc,tStr,&teW,&teH,linespace);
		tmpWidth=teW;
		tmpHigh=teH;
		dHigh=(double)tmpHigh;
		if (dHigh > rowHigh) { rowHigh=dHigh; };
		if (++c>cols)
		{
			totHigh+=rowHigh; 
			rowHigh=0; 	 c=1;
		}
		currRec++;
		if ((recPerPage > 0)&&(row!=NULL))
		{ hitPageMax=(recPerPage<=currRec); }
	}
	db->FreeQuery(qry);
}
	if ((qCnt < cols)&&(qCnt > 0)) { cols=qCnt; };
	currRec=0;
	hitPageMax=0;
	//set scale
	wxString lalaStr;
	if (ceil(totHigh*scaley) >= where.height)
	{
//	lalaStr.Printf("Scaled back : %.2f > %u : oldscale=%.2f, newscale=",scaley*totHigh,where.height,scaley);
	scalex=(double)where.height/(totHigh) ;
	scaley=(double)where.height/(totHigh) ;
//	tStr.Printf("%.2f, new High: %.2f",scaley,totHigh*scaley);
//	lalaStr.Append(tStr);
//	wxMessageBox(lalaStr,"debug",-1,this->parent);
	}

wxCoord cX,cY;
//draw the strings
cX=where.x;
cY=where.y;
if (cols>1)
{ colWidth=(double)qWidth/(double)cols - ((double)vSpacing/(double)(cols-1)); }
else
{ colWidth=qWidth; }
colWidth=colWidth*(double)myPPIx/scalex;
//wxGetTextFromUser("Query Text","Query",sQuery,gProg);
if (qry=db->Query(sQuery.c_str(),sQuery.Length()))
{
	c=1;
	rowHigh=0;
	while (((row=db->FetchRow(qry))!=NULL)&&(!hitPageMax))		//new line
	{
		max=db->FetchNumCols(qry,row);
		tStr="";
		for (i=0; i<max;i++)
		{
			tStr.Append(db->FetchQueryResult(qry,row,i));
		}
		dc.SetUserScale(scalex,scaley);
		MyTextExtent(dc,tStr,&teW,&teH,linespace);
		tmpWidth=teW;
		tmpHigh=teH;
		dc.SetDeviceOrigin(cX,cY);
//		dc.DrawLine(tmpWidth,tmpHigh,tmpWidth,0);
//		dc.DrawLine(0,tmpHigh,tmpWidth,tmpHigh);
		if (tmpWidth>=colWidth)
		{ 

			tscale=(double)colWidth/(double)tmpWidth; 
			dc.SetUserScale(tscale*scalex,tscale*scaley);
			tmpWidth*=(scalex*tscale);
			tmpHigh*=(scaley*tscale);

		} else {
		tmpWidth*=scalex;
		tmpHigh*=scaley;
		}
		MyDrawText(dc,tStr,0,0,linespace);

		if (tmpHigh > rowHigh) { rowHigh=tmpHigh; };
		cX+=where.width/cols;
		if (++c>cols)
		{
			c=1;
			cX=where.x;
			cY+=rowHigh; //todo - vspacing
			rowHigh=0;
		}
		if ((recPerPage > 0)&&(row!=NULL))
		{ hitPageMax=(recPerPage<=++currRec); }
	}
	db->FreeQuery(qry);
} else { 
		row=NULL;
	if (db->IsError())
	{
		tStr.Printf("Query Error - %s - %s",qName.c_str(),db->GetError());
		LOG_ERROR(tStr.c_str());
	
	//	wxMessageBox(db->GetError(),"Query Error",wxOK,gProg==NULL?this->parent:gProg); }; 
	}
}
	if ((recPerPage > 0)&&(row!=NULL))
	{ this->morePages=(morePages||hitPageMax); }
//dc.SetDeviceOrigin(0,0);
//dc.SetUserScale(1,1);
}

void brRunner::DrawText(RECORD_ID queryId,wxDC & dc,wxRect & where,int p)
{
	wxFont tFont,oFont;
 	LoadFont(queryId,tFont);
	oFont=dc.GetFont();
	dc.SetFont(tFont);
	DrawString(queryId,dc,where,p);
	dc.SetFont(oFont);
}

void brRunner::DrawImage(RECORD_ID queryId,wxDC & dc,wxRect & where,int p)
{
bcPicture *picture;
QRY_ID qry;
void *row;
//char *tmp;
wxString tStr,sQuery;
int max,cols,c;
char *tmp;
wxCoord hSpacing,vSpacing;
wxCoord rowHigh,tmpHigh,totHigh,tmpWidth;

double qHigh,qWidth,colWidth,scale,tscale;

qHigh=db->GetFValue("reportQueryLayouts","height",queryId);
qWidth=db->GetFValue("reportQueryLayouts","width",queryId);
hSpacing=db->GetFValue("reportQueryLayouts","hSpacing",queryId);
vSpacing=db->GetFValue("reportQueryLayouts","vSpacing",queryId);
if (tmp=db->GetValue("reportQueryLayouts","recordsPerRow",queryId))
{ cols=atoi(tmp); } else { cols=1; }
if (cols==0) { cols=1; }

int recPerPage=0,currRec=0;
wxString limitStr;
bool hitPageMax=false;
recPerPage=db->GetIValue("reportQueryLayouts","RecordsPerPage",queryId);
limitStr="";
this->GetQuery(queryId,sQuery);
if (recPerPage > 0)
{
	if (p<=1)
	{ limitStr.Printf(" LIMIT %d",recPerPage+1); }
	else
	{ limitStr.Printf(" LIMIT %d,%d",recPerPage*(p-1),recPerPage+1); }
	sQuery.Append(limitStr.c_str());
}

scale=((double)where.height/(double)qHigh)/(double)this->ScreenPPI;
//dc.SetUserScale(scale,scale);
// determine total height
totHigh=0;
int qCnt=0;
if (qry=db->Query(sQuery.c_str(),sQuery.Length()))
{
	c=1;
	rowHigh=0;
	while (((row=db->FetchRow(qry))!=NULL)&&(!hitPageMax))		//new line
	{
		qCnt++;
		max=db->FetchNumCols(qry,row);
		//new line
		tStr="";
		picture=new bcPicture();
		picture->LoadFromQueryResults(db,qry,row,0);
		if (picture->Ok())
		{
		tmpHigh=picture->GetHeight();		
		if (tmpHigh > rowHigh) { rowHigh=tmpHigh; };
		if (++c>cols)
		{
			c=1;
			totHigh+=rowHigh; //todo vspacing
			rowHigh=0;
		}
		}
		safe_delete(picture);
		if ((recPerPage > 0)&&(row!=NULL))
		{ hitPageMax=(recPerPage<=++currRec); }
	}
	db->FreeQuery(qry);
} else { row=NULL; }
	if ((recPerPage > 0)&&(row!=NULL))
	{ this->morePages=(morePages||hitPageMax); }
//set scale
	if (totHigh > where.height)
	{
		scale=where.height * scale/(double)totHigh;
	}
	if ((qCnt < cols)&&(qCnt > 0)) { cols=qCnt; };
wxCoord cX,cY;
//draw the strings
cX=where.x;
cY=where.y;
if (cols>1)
{ colWidth=(double)qWidth/(double)cols - ((double)vSpacing/(double)(cols-1)); }
else
{ colWidth=qWidth; }
colWidth*=((double)where.width/(double)qWidth);
wxRect imRect,atRect;
if (qry=db->Query(sQuery.c_str(),sQuery.Length()))
{
	c=1;
	rowHigh=0;
	hitPageMax=false;
	while (((row=db->FetchRow(qry))!=NULL)&&(!hitPageMax))		//new line
	{
		picture=new bcPicture();
		picture->LoadFromQueryResults(db,qry,row,0);
		if (picture->Ok())
		{
		tmpWidth=picture->GetWidth() * scale;
		tmpHigh=picture->GetHeight() * scale;
		imRect.x=0;imRect.y=0;
		imRect.width=picture->GetWidth();
		imRect.height=picture->GetHeight();
		if (tmpWidth>colWidth)
		{ 
			tscale = ((double)colWidth/(double)tmpWidth) * scale; 
			if (tscale<scale)
			{ 
//				dc.SetUserScale(tscale,tscale);
			} else { tscale=scale; }
			atRect.width=imRect.width*tscale;
			atRect.height=imRect.height*tscale;
		} else  {
			atRect.width=imRect.width*scale;
			atRect.height=imRect.height*scale;
		}
		atRect.x=cX;
		atRect.y=cY;
		DrawImageChunks(*picture,dc,imRect,atRect);
		
		if (tmpHigh > rowHigh) { rowHigh=tmpHigh; };
		cX+=where.width/cols;
		if (++c>cols)
		{
			c=1;
			cX=where.x;
			cY+=rowHigh; //todo - vspacing
			rowHigh=0;
		}
		}
		safe_delete(picture);
		if ((recPerPage > 0)&&(row!=NULL))
		{ hitPageMax=(recPerPage<=++currRec); }
	}
	db->FreeQuery(qry);
} else { if (db->IsError()) { LOG_ERROR(db->GetError()); }; row=NULL; };
	if ((recPerPage > 0)&&(row!=NULL))
	{ this->morePages=(morePages||hitPageMax); }

//dc.SetDeviceOrigin(0,0);
//dc.SetUserScale(1,1);
}

void brRunner::DrawSubReport(RECORD_ID queryId,wxDC & dc,wxRect & where,int p)
{
QRY_ID qry;
void *row;
//char *tmp;
brRunner *subRunner;
wxString tStr,sQuery;
int max,i,cols,c;
char *tmp;
wxCoord hSpacing,vSpacing;
wxCoord rowHigh,tmpHigh,totHigh,tmpWidth;
wxCoord cX,cY;
double qHigh,qWidth,colWidth,scale;
int rowsHigh;
//draw the strings

wxRect imRect,atRect;
wxString pName;
wxString qName;
qName=db->GetValue("reportQueries","name",queryId);

RECORD_ID subId;
long numRows;

qHigh=db->GetFValue("reportQueryLayouts","height",queryId);
qWidth=db->GetFValue("reportQueryLayouts","width",queryId);
hSpacing=db->GetFValue("reportQueryLayouts","hSpacing",queryId);
vSpacing=db->GetFValue("reportQueryLayouts","vSpacing",queryId);
double myPPI;
myPPI=((double)where.height/(double)qHigh);

if (tmp=db->GetValue("reportQueryLayouts","recordsPerRow",queryId))
{ cols=atoi(tmp); } else { cols=1; }
if (cols==0) { cols=1; }
if (tmp=db->GetValue("reportQueryLayouts","subReportId",queryId))
	{ subId=atoi(tmp); } else { return; }
cX=where.x;
cY=where.y;

int recPerPage=0,currRec=0;
wxString limitStr;
bool hitPageMax=false;
recPerPage=db->GetIValue("reportQueryLayouts","RecordsPerPage",queryId);
limitStr="";
this->GetQuery(queryId,sQuery);
if (recPerPage > 0)
{
	if (p<=1)
	{ limitStr.Printf(" LIMIT %d",recPerPage+1); }
	else
	{ limitStr.Printf(" LIMIT %d,%d",recPerPage*(p-1),recPerPage+1); }
	sQuery.Append(limitStr.c_str());
}
//this->GetQuery(queryId,sQuery);
//scale=(double)myPPI/(double)this->ScreenPPI;
//scale=1;
if (qry=db->Query(sQuery.c_str(),sQuery.Length()))
{
	subRunner=new brRunner(parent,db,subId);
	currRec=0;
	c=1;
	rowHigh=0;
	// determine total height
	numRows=db->FetchNumRows(qry);
	if ((recPerPage > 1)&&(numRows>recPerPage))
	{ numRows=recPerPage; } //should only be one more - being safe
	//divide by cols - multiply by where.height/qHigh
	if (numRows < cols) { cols=numRows; rowsHigh=1; } 
	else { rowsHigh=ceil((double)numRows/(double)cols); }

	if (cols>1)
	{ colWidth=(qWidth/(double)cols) - (vSpacing/(double)(cols-1)); }
	else
	{ colWidth=qWidth; }
	colWidth=ceil(colWidth*(double)myPPI);

	totHigh=rowsHigh * myPPI * db->GetFValue("reportLayouts","height",subId);
	//add vSpacing * (where.height/qHigh) * (rows-1)
	totHigh+=(vSpacing * myPPI * (rowsHigh - 1)); 
	//that should be total height

	//determine scaling factor
	if (totHigh > where.height)
	{
		scale=(double)where.height / (double)totHigh;
	} else { scale=1; }

	while (((row=db->FetchRow(qry))!=NULL)&&(!hitPageMax)&&(!cancelReport))		//new line
	{
		imRect.x=cX;
		imRect.y=cY;

		imRect.width=floor(db->GetFValue("reportLayouts","width",subId) * (double)myPPI *  scale);
		imRect.height=floor(db->GetFValue("reportLayouts","height",subId)  * (double)myPPI * scale);

		tmpWidth=imRect.width ;
		tmpHigh=imRect.height ;

		if (tmpWidth>colWidth)
		{ 
			scale=scale*(double)colWidth/(double)tmpWidth;
			imRect.width=colWidth;
			imRect.height*=scale;
//			dc.SetUserScale(tscale,tscale);
		};

		max=db->FetchNumCols(qry,row);
		subRunner->ClearParameters();
		subRunner->SetParameter(wxString("PAGE"),wxString("1"));
		//fill parameter values
		for (i=0;i<max; i++)
		{
			tStr.Printf("select name from reportParameters where reportId=%u and runOrder=%d",subId,i+1);
			pName=db->GetQueryValue(tStr.c_str());
			tStr=db->FetchQueryResult(qry,row,i);
			subRunner->SetParameter(pName,tStr);
		}
//		dc.SetDeviceOrigin(cX*tscale,cY*tscale);
//		dc.DrawRectangle(imRect.x,imRect.y,imRect.width,imRect.height);
		//only display first page of subreports - maybe change later
		subRunner->DrawReport(subId,dc,imRect,1); 
		this->cancelReport=subRunner->cancelReport;	
		if (tmpHigh > rowHigh) { rowHigh=tmpHigh; };
		cX+=ceil((double)where.width/(double)cols);
		if (++c>cols)
		{
			c=1;
			cX=where.x;
			cY+=rowHigh;
			cY+=vSpacing * myPPI; //todo - vspacing
			rowHigh=0;
		}
		if (recPerPage > 0)
		{ hitPageMax=(recPerPage<=++currRec); }
	}
	db->FreeQuery(qry);
	this->cancelReport=subRunner->cancelReport;
	safe_delete(subRunner);
	if ((recPerPage > 0)&&(row!=NULL))
	{ this->morePages=(morePages||hitPageMax); }
} else {
	if (db->IsError())
	{
		tStr.Printf("Query Error - %s - %s",qName.c_str(),db->GetError());
		LOG_ERROR(tStr.c_str());
	//	wxMessageBox(db->GetError(),"Query Error",wxOK,gProg==NULL?this->parent:gProg); }; 
	}
}
//		dc.SetUserScale(1,1);
}

void brRunner::ClearParameters()
{
	this->aParamName.Empty();
	this->aParamValue.Empty();
}

void brRunner::SetParameter(wxString &parameter, wxString &value)
{
	int i;
	i=this->aParamName.Index(parameter.c_str());
	if (i>=0)
	{ this->aParamValue[i]=value; }
	else
	{ this->aParamName.Add(parameter);
		this->aParamValue.Add(value);
	}
}

bool brRunner::GetParameters(RECORD_ID reportId)
{
	QRY_ID qry;
	void *row;
	wxString tStr;
	char *tmp;
	RECORD_ID triggerId;
	tStr.Printf("select id from reportParameters where reportId=%u order by runOrder",reportId);
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		while (row=db->FetchRow(qry)) {
			if (tmp=db->FetchQueryResult(qry,row,0))
			{
				triggerId=atoi(tmp);
				if (!GetParameter(triggerId))
				{
					db->FreeQuery(qry);
					return false; 
				}
			}
		}
	db->FreeQuery(qry);
	}
	return true;
}

bool brRunner::GetParameter(RECORD_ID parameterId)
{
int pType;
char *tmp;
int intval;
wxString tStr,prompt,name;
RECORD_ID recordVal;
wxString dateVal;
//double moneyVal;
BOLTChooser *bc;
wxArrayString fArray;
wxString table;
wxDateTime tDate;
wxCalendarCtrl *cCtrl;
wxDialog *tDlg;
wxBoxSizer *topSizer;
		wxString qpClass;
name=db->GetValue("reportParameters","name",parameterId);
if (this->aParamName.Index(name.c_str())>=0)
	{ return true; }
if (tmp=db->GetValue("reportParameters","paramType",parameterId))
{
	pType=atoi(tmp);
	prompt=db->GetValue("reportParameters","prompt",parameterId);
	switch (pType) {
	case PT_DATE: 
		tDlg=new wxDialog(parent,-1,"Parameter",wxDefaultPosition);
		topSizer=new wxBoxSizer(wxHORIZONTAL);
		topSizer->Add(new wxStaticText(tDlg,-1,prompt));
		topSizer->Add(cCtrl=new wxCalendarCtrl(tDlg,-1),1,wxEXPAND|wxALL,5);
		topSizer->Add(new wxButton(tDlg,wxID_OK,"&Ok"),0,wxALIGN_CENTER|wxALL,5);
		topSizer->Add(new wxButton(tDlg,wxID_CANCEL,"&Cancel"),0,wxALIGN_CENTER|wxALL,5);
//		tDlg->SetAutoLayout(TRUE);
		tDlg->SetSizerAndFit(topSizer);
		topSizer->SetSizeHints(tDlg);
		topSizer->Fit(tDlg);
		tDlg->Center();
		cCtrl->SetFocus();
		if (tDlg->ShowModal()==wxID_OK)
		{
			tDate=cCtrl->GetDate();
			tStr.Printf("%d-%d-%d",tDate.GetYear(),
							tDate.GetMonth()+1,tDate.GetDay());
			this->SetParameter(name,tStr);
			tDlg->Destroy();
			return true;
		}
		tDlg->Destroy();
		break;
	case PT_MONEY: 
	case PT_NUMBER: 
		intval=wxGetNumberFromUser(prompt,"Value","Caption",0,0,999999,parent);
		if (intval>=0) {
			tStr.Printf("%d",intval);
			this->SetParameter(name,tStr);
			return true;
		}
		return false;
		break;
	case PT_QUICKPICK: 
		bc=new BOLTChooser(db,parent,-1);
		//

		qpClass=db->GetValue("reportParameters","paramClass",parameterId);
		if (qpClass.IsEmpty())
		{
			LOG_ERROR("UNKNOWN QUICKPICK CLASS");
			return true;
		}
		bc->AddQuickPicks(qpClass);
		bc->SetTitle(prompt);
/*		table="accounts";
		fArray.Add("firstname");
		fArray.Add("middlename");fArray.Add("lastname");
		fArray.Add("extraname");fArray.Add("ssn");
		fArray.Add("idNumber");fArray.Add("id2Number");
		fArray.Add("homephone");fArray.Add("workphone");
		fArray.Add("dateOfBirth");
		bc->SetSearchFields(table,fArray);
*/
		if (recordVal=bc->GetChoice(false,NULL,true))
		{
			tStr.Printf("%u",recordVal);
			this->SetParameter(name,tStr);
			bc->Destroy();
			return true;
		}
		bc->Destroy();
		return false;
		break;
	default:
		LOG_ERROR("UNKNOWN PARAMETER TYPE");
		return true;
		break;
	}
}
return false;
}

void brRunner::GetQuery(RECORD_ID queryId, wxString &query)
{
	char *tmp;
	wxString tStr;
//	wxNode *data;
	QRY_ID qry;
	void *row;
	wxString label,tLabel;
	wxString value;
	RECORD_ID reportId;
	if (tmp=db->GetValue("reportQueries","reportId",queryId))
		{ reportId=atoi(tmp); } else { return; }
	query=db->GetValue("reportQueries","query",queryId);
	//now replace any parameters
	int i;
	tStr.Printf("select name from reportParameters where reportId=%u order by runOrder",reportId);
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		while (row=db->FetchRow(qry))
		{
			label=db->FetchQueryResult(qry,row,0);
			i=this->aParamName.Index(label);
			if (i>=0)
			{
				value=this->aParamValue[i];
				tLabel=label;
				label.Printf("%%%s%%",tLabel.c_str());
				query.Replace(label.c_str(),value.c_str(),TRUE);
			} 
		}
		db->FreeQuery(qry);
	}
	i=this->aParamName.Index("PAGE");
	if (i>=0)
	{
		value=this->aParamValue[i];
		tLabel=label;
		label.Printf("%%%PAGE%%");
		query.Replace(label.c_str(),value.c_str(),TRUE);
	} 

}

brRunner::~brRunner()
{
	this->ClearParameters();
	this->aParamName.Clear();
	this->aParamValue.Clear();
}

void brRunner::LoadFont(RECORD_ID queryId,wxFont &font)
{
	char *tmp;
//	int t;
	font.SetFaceName(db->GetValue("reportQueryLayouts","fontName",queryId));
	if (tmp=db->GetValue("reportQueryLayouts","fontSize",queryId))
	{ font.SetPointSize(atoi(tmp)); }
	if (tmp=db->GetValue("reportQueryLayouts","fontStyle",queryId))
	{ font.SetStyle(atoi(tmp)); }
	if (tmp=db->GetValue("reportQueryLayouts","fontWeight",queryId))
	{ font.SetWeight(atoi(tmp)); }
	tmp=db->GetValue("reportQueryLayouts","fontUnderline",queryId);
	font.SetUnderlined(!(tmp==NULL));
}

bool brRunner::TriggerReport(RECORD_ID objectId, const char *triggerName,wxArrayString * params)
{
	QRY_ID qry,qry2;
	void *row,*row2;
	char *tmp;
	RECORD_ID triggerId,reportId,paramId;
	wxString tStr,pStr;
	wxString path,user,pass,host,printerName;
	int style;
	int qty,i;
	unsigned int rp;
	bool text,pasv;
	wxPrintData pdata;
	int p; //page number

//	cancelReport=false;
	this->parent->Freeze();
	tStr.Printf("select id from reportTriggers where name='%s'",triggerName);
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		while ( (row=db->FetchRow(qry)) && (!cancelReport))
		{
			if (tmp=db->FetchQueryResult(qry,row,0))
			{
				triggerId=atoi(tmp);
				if (tmp=db->GetValue("reportTriggers","reportId",triggerId))
				{
					reportId=atoi(tmp); 

	//set parameters
	this->ClearParameters();

	tStr.Printf("select id from reportParameters where reportId=%u order by runOrder",reportId);
	if (qry2=db->Query(tStr.c_str(),tStr.Length()))
	{
	rp=0;
	while ((row2=db->FetchRow(qry2))  && (!cancelReport))
	{	
		tmp=db->FetchQueryResult(qry2,row2,0);
		paramId=atoi(tmp);

		if (tmp=db->GetValue("reportParameters","name",paramId))
		{
			pStr=tmp;
			if ((params!=NULL)&&(params->GetCount()>rp++))
			{
				tStr=params->Item(rp-1);
				this->SetParameter(pStr,tStr);
			} else
			{
				if (objectId>0)
				{
					tStr.Printf("%u",objectId);
					this->SetParameter(pStr,tStr);
				}
			}
		}
	}
	db->FreeQuery(qry2);
	}

				//set trigger value
				//figure out the trigger type
					if (tmp=db->GetValue("reportTriggers","outputStyle",triggerId))
						{ style=atoi(tmp); } else { style=0; }
					if (tmp=db->GetValue("reportTriggers","runAmount",triggerId))
						{ qty=atoi(tmp); } else { qty=1; }
				for (i=0;(i<qty)  && (!cancelReport);i++)
				{
					p=0;
					do { p++; 
					switch(style)
					{
					case 0: //screen
						this->DoViewReport(reportId,p);
						break;
					case 1: //printer
						//printer=?
						printerName=db->GetValue("reportTriggers","printer",triggerId);
						pdata=wxGetApp().frame->psData.GetPrintData();
						pdata.SetPrinterName(printerName);
						pdata.SetPaperId((wxPaperSize)db->GetIValue("reportTriggers","paperSize",triggerId));

						int poptions,pquality;
							poptions=db->GetIValue("reportTriggers","paperOptions",triggerId);
							pdata.SetOrientation(poptions);
							poptions=db->GetIValue("reportTriggers","printColor",triggerId);
							pdata.SetColour(poptions==1);
							poptions=db->GetIValue("reportTriggers","printDuplex",triggerId);
							pdata.SetDuplex(poptions==0?wxDUPLEX_SIMPLEX:poptions==1?wxDUPLEX_HORIZONTAL:wxDUPLEX_VERTICAL);
							poptions=db->GetIValue("reportTriggers","printCollate",triggerId);
							pdata.SetCollate(poptions==1);
							pquality=db->GetIValue("reportTriggers","printQuality",triggerId);
							pdata.SetQuality(pquality);
	
						if (!pdata.Ok())
						{
							wxPageSetupDialog *printWin;
							wxPageSetupDialogData printData;
							printData.EnableMargins(FALSE);
							printData.SetPrintData(pdata);
							printWin=new wxPageSetupDialog(this->parent,&printData);
							//printData.GetPrintData(pData)
							//printWin->GetPageSetupData().SetSetupDialog(TRUE);
							if (printWin->ShowModal()==wxID_OK)
							{
							//	printData=printWin->GetPrintDialogData();
								printData=printWin->GetPageSetupData().GetPrintData();
								printData.SetMarginTopLeft(wxPoint(0,0));
								printData.SetMarginBottomRight(wxPoint(0,0));
								pdata=printData.GetPrintData();
							}
							printWin->Destroy();
						}
						this->DoPrintReport(reportId,pdata,p);

						break;
					case 2: //save
						path=db->GetValue("reportTriggers","path",triggerId);
						text=db->GetValue("reportTriggers","textOnly",triggerId)!=NULL;
						this->DoSaveReport(reportId,path,text,p);
						break;
					case 3: //send
						host=db->GetValue("reportTriggers","server",triggerId);
						path=db->GetValue("reportTriggers","path",triggerId);
						user=db->GetValue("reportTriggers","username",triggerId);
						pass=db->GetValue("reportTriggers","password",triggerId);
						text=db->GetValue("reportTriggers","textOnly",triggerId)!=NULL;
						pasv=db->GetValue("reportTriggers","passive",triggerId)!=NULL;
						this->DoSendReport(reportId,path,host,user,pass,text,pasv,p);
						break;
						//run appropriate commands
					}
					} while (this->HasMorePages());
				}
				}
			}
		}
		db->FreeQuery(qry);
	}
	this->parent->Thaw();
	return true;
}

void brRunner::DrawBitmapChunks(wxBitmap &bitmap, wxDC &dc, wxRect bmRect, wxRect dcRect)
{
	int wi=dcRect.width;
	int hi=dcRect.height;

	wxMemoryDC memDC;
	memDC.SelectObject(bitmap);
	memDC.SetDeviceOrigin(bmRect.x,bmRect.y);
	memDC.SetUserScale((double)wi/bmRect.width,(double)hi/bmRect.height);
//#define DRAW(r,x,y) dc->DrawBitmap(tBitmap->GetSubBitmap(r),x,y)
#define DRAW(sx,sy,w,h) dc.Blit(dcRect.x+sx,dcRect.y+sy,w,h,&memDC,sx,sy)
//todo draw in little chunks
	int i,j;
	int csize=128;
	for (i=0;(i+csize)<wi;i+=csize) {
		for (j=0;(j+csize)<hi;j+=csize) {
		DRAW(i,j,csize,csize);	
		}
		j-=csize; //go back
		DRAW(i,j,csize,hi-j);
	};
	i-=csize;
	for (j=0;(j+csize)<hi;j+=csize) {
		DRAW(i,j,wi-i,csize);	
	}
	j-=csize; //go back
	DRAW(i,j,wi-i,hi-j);
#undef DRAW
	memDC.SelectObject(wxNullBitmap);
}

void brRunner::DrawImageChunks(wxImage &image, wxDC &dc, wxRect imRect, wxRect dcRect)
{
	int wi=imRect.width;
	int hi=imRect.height;

	dc.SetDeviceOrigin(dcRect.x,dcRect.y);
	dc.SetUserScale((double)dcRect.width/(double)imRect.width,
		(double)dcRect.height/(double)imRect.height);
//#define DRAW(r,x,y) dc->DrawBitmap(tBitmap->GetSubBitmap(r),x,y)
//todo draw in little chunks
#define DRAW(r,a,b) dc.DrawBitmap(image.GetSubImage(r).ConvertToBitmap(),a,b)
//todo draw in little chunks
	int i,j;
	int csize=4096;
//	double xSize=(double)(dcRect.width/imRect.width)*csize;
//	double ySize=(double)(dcRect.height/imRect.height)*csize;
	for (i=0;(i+csize)<wi;i+=csize) {
		for (j=0;(j+csize)<hi;j+=csize) {
		DRAW(wxRect(imRect.x+i,imRect.y+j,csize,csize),i,j);
		}
		if(j<hi)
		{
			DRAW(wxRect(imRect.x+i,imRect.y+j,csize,hi-j),i,j);
		}
	};
	if (i<wi)
	{
	for (j=0;(j+csize)<hi;j+=csize) {
		DRAW(wxRect(imRect.x+i,imRect.y+j,wi-i,csize),i,j);	
	}
	if (j<hi)
	{
		DRAW(wxRect(imRect.x+i,imRect.y+j,wi-i,hi-j),i,j);
	}
	}
#undef DRAW
//	dc.SetUserScale(1,1);
//	dc.SetDeviceOrigin(0,0);
}

#define textround(x) (floor(x+.05))
void brRunner::MyTextExtent(wxDC & dc,const wxString &string, wxCoord *w, wxCoord *h,double lSpace)
{
//	dc.GetTextExtent(string,w,h);	return;
//do the newline thing
	DOUBLE accW,accH,cH,cW;
	wxString tStr,rStr;
	cH=accW=accH=0;
	rStr=string;
	while (!rStr.IsEmpty())
	{
	tStr=rStr.BeforeFirst('\n');
	rStr=rStr.AfterFirst('\n');
	dc.GetTextExtent(tStr,w,h);
	if (tStr.IsEmpty()&&(!rStr.IsEmpty()))
	{ dc.GetTextExtent("|",w,h); } 
	cH=*h;
	cW=*w;
	if (cW>accW)
		{ accW=cW; } //greatest length
	accH+=(cH+textround(lSpace*(double)cH));
	}

	if (cH>0)
	{
		accH-=textround(lSpace*(double)cH);
	}
	*w=accW;
	*h=accH;
}

void brRunner::MyDrawText(wxDC &dc, const wxString &text, wxCoord x, wxCoord y,double lSpace)
{
//	dc.DrawText(text,x,y); return
//do the newline thing
	double accH;
		long cH=0,cW;
	wxString tStr,rStr;
	accH=y;
	rStr=text;
	while (!rStr.IsEmpty())
	{
	tStr=rStr.BeforeFirst('\n');
	rStr=rStr.AfterFirst('\n');
	dc.GetTextExtent(tStr,&cW,&cH);
	if (tStr.IsEmpty()&&(!rStr.IsEmpty()))
	{ dc.GetTextExtent("|",&cW,&cH); } 
	dc.DrawText(tStr,x,accH);
	accH+=(cH+textround(lSpace*(double)cH));
	}
	if (cH>0)
	{
		accH-=textround(lSpace*(double)cH);
	}
}

bool brRunner::HasMorePages()
{
	if (cancelReport) 
		{ return false; }
	else
		return (this->morePages);
}
